# {

> Multipurpose shell syntax.
> More information: <https://www.gnu.org/software/bash/manual/bash.html>.

- Isolate variable names:

`echo ${{{HOME}work}}`

- Brace expand sequences:

`echo {{{1..3}}} {{{a..c}}}{{{dir1,dir2,dir3}}}`

- Check if `variable` is set before returning text:

`echo ${{{variable:+variable is set and contains $variable}}}`

- Set default values in case `variable` is unset:

`echo ${{{variable:-default}}}`

- Return `variable` length in characters:

`echo ${{{#variable}}}`

- Return a string slice:

`echo ${{{variable:3:7}}}`

- Recursively expand a `variable`:

`echo ${{{!variable}}}`

- Group command output together:

`{ {{command1; command2; ...}} } | {{another_command}}`
